

#import <Cocoa/Cocoa.h>

// protocollo: i metodi che devono essere realizzati perche' questa
// classe possa essere utilizzata con profitto
@protocol	CurlWrapperController
// quando c'e' qualcosa da riportare indietro al task principale
- (void)appendOutput:(NSString *)output;
// callback alla partenza di un download
- (void)downloadStarted ;
// callback al termine di un download
- (void)downloadFinished ;

@end

@interface CurlWrapper : NSObject 
{
	// il task controllato da questa classe
	NSTask		* curltask ;
	// puntatore al task chiamante
	id			<CurlWrapperController> theCaller ;
	// il path del comando da lanciare
	NSString	* curlPath ;
	// la directory dove lanciare il programma
	NSString	* workingDir ;
}

// inizializzazione della classe con gli argomenti
- (id)initWithCaller: (id <CurlWrapperController>) aCaller inDir: (NSString*) workdir ;
// partenza delel operazioni
- (void) startDownloadWithArgs: (NSArray *) args ;
// fine delle operazioni
- (void) stopDownload ;

@end
